<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 03.12.13 12:44
 */

namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use VM\ApiBundle\Entity\Method;
use VM\ApiBundle\Entity\Service;

class LoadMethodsData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * @var array
     */
    protected $methods = array(
        array('symbol' => 'user_login', 'description' => 'Logowanie uzytkownika'),
        array('symbol' => 'user_check_token', 'description' => 'Sprawdzenie danych użytkownika'),
        array('symbol' => 'user_register', 'description' => 'Rejestracja użytkownika'),
        array('symbol' => 'user_registration_confirm', 'description' => 'Potwierdzenie rejestracji'),
        array('symbol' => 'user_update', 'description' => 'Aktualizacja danych użytkownik'),
        array('symbol' => 'user_generate_password_recovery_token', 'description' => 'Generuje token umożliwiajacy odzyskanie hasła'),
        array('symbol' => 'user_change_password', 'description' => 'Ustawia nowe hasło uzytkownikowi'),
        array('symbol' => 'user_get', 'description' => 'Pobiera dane użytkownika'),
        array('symbol' => 'user_get_names', 'description' => 'Pobiera imie i nazwisko użytkowników o zadanych ID'),
        array('symbol' => 'user_get_roles', 'description' => 'Pobiera uprawnienia użytkownika w danej aplikacji'),
        array('symbol' => 'user_set_roles', 'description' => 'Ustawia uprawnienia użytkownika w danej aplikacji'),
        array('symbol' => 'user_app_update', 'description' => 'Bez tokena pozwala zmienić imię i nazwisko'),
        array('symbol' => 'user_app_delete', 'description' => 'Bez tokena pozwala usunąć użytkownika'),
        array('symbol' => 'user_logout', 'description' => 'Wylogowuje użytkownika'),
    );


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $Manager)
    {
        foreach($this->methods as $methodData)
        {
            $Method = new Method();
            $Method->setSymbol($methodData['symbol']);
            $Method->setDescription($methodData['description']);
            $Manager->persist($Method);

            $this->setReference($methodData['symbol'], $Method);

            $Manager->flush();
        }
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 1;
    }
}